/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data.gen.feature;

import com.mojang.datafixers.util.Pair;
import com.terraforged.mod.biome.ModBiomes;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.data.gen.FeatureInjectorProvider;
import com.terraforged.mod.feature.TerraFeatures;
import com.terraforged.mod.feature.context.ContextSelectorConfig;
import com.terraforged.mod.feature.context.ContextSelectorFeature;
import com.terraforged.mod.feature.context.ContextualFeature;
import com.terraforged.mod.feature.context.modifier.BiomeModifier;
import com.terraforged.mod.feature.context.modifier.ContextModifier;
import com.terraforged.mod.feature.context.modifier.Elevation;
import com.terraforged.mod.feature.decorator.FilterDecorator;
import com.terraforged.mod.feature.decorator.filter.FilterDecoratorConfig;
import com.terraforged.mod.feature.decorator.filter.PlacementFilter;
import com.terraforged.mod.feature.decorator.poisson.FastPoissonAtSurface;
import com.terraforged.mod.feature.decorator.poisson.FastPoissonConfig;
import com.terraforged.mod.featuremanager.matcher.biome.BiomeMatcher;
import com.terraforged.mod.featuremanager.matcher.feature.FeatureMatcher;
import com.terraforged.mod.featuremanager.modifier.Jsonifiable;
import com.terraforged.mod.featuremanager.modifier.Modifier;
import com.terraforged.mod.featuremanager.template.template.TemplateManager;
import com.terraforged.mod.featuremanager.transformer.FeatureReplacer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;

public class Trees {
    public static void addInjectors(FeatureInjectorProvider provider) {
        provider.add("trees/acacia", Trees.acacia(provider.getContext()));
        provider.add("trees/oak_badlands", Trees.oakBadlands(provider.getContext()));
        provider.add("trees/oak_wooded_badlands", Trees.oakWoodedBadlands(provider.getContext()));
        provider.add("trees/oak_forest", Trees.oakForest(provider.getContext()));
        provider.add("trees/oak_plains", Trees.oakPlains(provider.getContext()));
        provider.add("trees/birch", Trees.birch(provider.getContext()));
        provider.add("trees/birch_oak", Trees.birchOak(provider.getContext()));
        provider.add("trees/dark_oak", Trees.darkForest(provider.getContext()));
        provider.add("trees/fir_forest", Trees.firForest(provider.getContext()));
        provider.add("trees/flower_plains", Trees.flowerForest(provider.getContext()));
        provider.add("trees/jungle", Trees.jungle(provider.getContext()));
        provider.add("trees/jungle_edge", Trees.jungleEdge(provider.getContext()));
        provider.add("trees/jungle_hills", Trees.jungleHills(provider.getContext()));
        provider.add("trees/pine", Trees.pine(provider.getContext()));
        provider.add("trees/redwood", Trees.redwood(provider.getContext()));
        provider.add("trees/spruce", Trees.spruce(provider.getContext()));
        provider.add("trees/spruce_tundra", Trees.spruceTundra(provider.getContext()));
        provider.add("trees/willow", Trees.willow(provider.getContext()));
    }

    private static Modifier<Jsonifiable> acacia(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, Biome.Category.SAVANNA), FeatureMatcher.and(Blocks.field_196621_O, Blocks.field_196572_aa), FeatureReplacer.of(Trees.extra(0, 0.225f, 1, "terraforged:acacia_large", Pair.of((Object)"terraforged:acacia_large", (Object)Float.valueOf(0.4f)), Pair.of((Object)"terraforged:acacia_small", (Object)Float.valueOf(0.15f)))));
    }

    private static Modifier<Jsonifiable> oakBadlands(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:shattered_savanna*", "minecraft:modified_badlands*"), FeatureMatcher.and(Blocks.field_196617_K, Blocks.field_196642_W), FeatureReplacer.of(Trees.extra(0, 0.02f, 3, "terraforged:oak_small", Pair.of((Object)"terraforged:oak_small", (Object)Float.valueOf(0.2f)), Pair.of((Object)"terraforged:acacia_bush", (Object)Float.valueOf(0.1f)))));
    }

    private static Modifier<Jsonifiable> oakWoodedBadlands(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:wooded_badlands*", "minecraft:modified_wooded*"), FeatureMatcher.and(Blocks.field_196617_K, Blocks.field_196642_W), FeatureReplacer.of(Trees.poisson(0.2f, 0.8f, 8, 0.25f, 150, 0.75f, "terraforged:oak_small", Pair.of((Object)"terraforged:oak_small", (Object)Float.valueOf(0.3f)), Pair.of((Object)"terraforged:acacia_bush", (Object)Float.valueOf(0.2f)))));
    }

    private static Modifier<Jsonifiable> oakForest(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:forest"), FeatureMatcher.and(Blocks.field_196617_K, Blocks.field_196642_W), FeatureReplacer.of(Trees.poisson(0.25f, 7, 0.3f, 150, 0.75f, "terraforged:oak_forest", Pair.of((Object)"terraforged:oak_forest", (Object)Float.valueOf(0.2f)), Pair.of((Object)"terraforged:oak_large", (Object)Float.valueOf(0.3f)))));
    }

    private static Modifier<Jsonifiable> oakPlains(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:river", "minecraft:plains", "minecraft:sunflower_plains", "minecraft:mountains"), FeatureMatcher.and(Blocks.field_196617_K, Blocks.field_196642_W), FeatureReplacer.of(Trees.extra(0, 0.02f, 1, "terraforged:oak_forest", Pair.of((Object)"terraforged:oak_forest", (Object)Float.valueOf(0.2f)), Pair.of((Object)"terraforged:oak_large", (Object)Float.valueOf(0.3f)))));
    }

    private static Modifier<Jsonifiable> firForest(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:snowy_mountains", "minecraft:wooded_mountains", "terraforged:fir_forest", "terraforged:snowy_fir_forest"), FeatureMatcher.and(Blocks.field_196618_L, Blocks.field_196645_X), FeatureReplacer.of(Trees.context(Trees.contextEntry("terraforged:spruce_small", 0.1f, Trees.eCntx(0.55f, 0.2f)), Trees.contextEntry("terraforged:spruce_large", 0.25f, Trees.eCntx(0.3f, 0.0f))).func_227228_a_(Trees.poisson(0.25f, 4, 0.3f, 300, 0.6f))));
    }

    private static Modifier<Jsonifiable> flowerForest(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, Biomes.field_185444_T, ModBiomes.FLOWER_PLAINS), FeatureMatcher.and(Blocks.field_196619_M, Blocks.field_196647_Y, Blocks.field_196617_K, Blocks.field_196642_W), FeatureReplacer.of(Trees.poisson(0.2f, 8, 0.1f, 500, 0.75f, "terraforged:birch_forest", Pair.of((Object)"terraforged:birch_forest", (Object)Float.valueOf(0.2f)), Pair.of((Object)"terraforged:birch_large", (Object)Float.valueOf(0.2f)), Pair.of((Object)"terraforged:oak_forest", (Object)Float.valueOf(0.2f)), Pair.of((Object)"terraforged:oak_large", (Object)Float.valueOf(0.2f)))));
    }

    private static Modifier<Jsonifiable> birch(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:birch*", "minecraft:tall_birch*"), FeatureMatcher.and(Blocks.field_196619_M, Blocks.field_196647_Y), FeatureReplacer.of(Trees.context(Trees.contextEntry("terraforged:birch_large", 0.2f, Trees.eCntx(0.25f, 0.0f), Trees.bCntx(0.1f, 0.3f)), Trees.contextEntry("terraforged:birch_forest", 0.2f, Trees.eCntx(0.3f, 0.0f), Trees.bCntx(0.05f, 0.2f)), Trees.contextEntry("terraforged:birch_small", 0.1f, Trees.bCntx(0.25f, 0.0f)), Trees.contextEntry("terraforged:birch_small", 0.1f, Trees.eCntx(0.25f, 0.65f))).func_227228_a_(Trees.poisson(0.25f, 6, 0.25f, 175, 0.9f))));
    }

    private static Modifier<Jsonifiable> birchOak(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:wooded_hills"), FeatureMatcher.and(Blocks.field_196619_M, Blocks.field_196647_Y, Blocks.field_196617_K, Blocks.field_196642_W), FeatureReplacer.of(Trees.poisson(0.25f, 4, 0.25f, 300, 0.75f, "terraforged:birch_forest", Pair.of((Object)"terraforged:birch_forest", (Object)Float.valueOf(0.2f)), Pair.of((Object)"terraforged:birch_large", (Object)Float.valueOf(0.2f)), Pair.of((Object)"terraforged:oak_forest", (Object)Float.valueOf(0.2f)), Pair.of((Object)"terraforged:oak_large", (Object)Float.valueOf(0.2f)))));
    }

    private static Modifier<Jsonifiable> darkForest(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:dark_forest", "minecraft:dark_forest_hills"), FeatureMatcher.and(Blocks.field_196623_P, Blocks.field_196574_ab), FeatureReplacer.of(Trees.poisson(0.3f, 5, 0.2f, 300, 0.75f, "terraforged:dark_oak_large", Pair.of((Object)"minecraft:huge_brown_mushroom", (Object)Float.valueOf(0.025f)), Pair.of((Object)"minecraft:huge_red_mushroom", (Object)Float.valueOf(0.05f)), Pair.of((Object)"terraforged:dark_oak_large", (Object)Float.valueOf(0.3f)), Pair.of((Object)"terraforged:dark_oak_small", (Object)Float.valueOf(0.2f)), Pair.of((Object)"terraforged:birch_forest", (Object)Float.valueOf(0.05f)), Pair.of((Object)"terraforged:oak_forest", (Object)Float.valueOf(0.025f)))));
    }

    private static Modifier<Jsonifiable> jungle(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:jungle", "minecraft:modified_jungle", "minecraft:bamboo_jungle"), FeatureMatcher.and("minecraft:tree"), FeatureReplacer.of(Trees.poisson(0.4f, 6, 0.2f, 400, 0.75f, "terraforged:jungle_small", Pair.of((Object)"terraforged:jungle_small", (Object)Float.valueOf(0.2f)), Pair.of((Object)"terraforged:jungle_large", (Object)Float.valueOf(0.3f)), Pair.of((Object)"terraforged:jungle_huge", (Object)Float.valueOf(0.4f)), Pair.of((Object)"minecraft:jungle_bush", (Object)Float.valueOf(0.5f)))));
    }

    private static Modifier<Jsonifiable> jungleEdge(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:jungle_edge", "minecraft:modified_jungle_edge", "terraforged:stone_forest"), FeatureMatcher.and("minecraft:tree"), FeatureReplacer.of(Trees.poisson(0.35f, 8, 0.25f, 350, 0.75f, "terraforged:jungle_small", Pair.of((Object)"terraforged:jungle_small", (Object)Float.valueOf(0.2f)), Pair.of((Object)"terraforged:jungle_large", (Object)Float.valueOf(0.3f)), Pair.of((Object)"minecraft:jungle_bush", (Object)Float.valueOf(0.4f)))));
    }

    private static Modifier<Jsonifiable> jungleHills(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:jungle_hills", "minecraft:bamboo_jungle_hills"), FeatureMatcher.or("minecraft:tree"), FeatureReplacer.of(Trees.poisson(0.35f, 7, 0.25f, 200, 0.75f, "terraforged:jungle_small", Pair.of((Object)"terraforged:jungle_small", (Object)Float.valueOf(0.3f)), Pair.of((Object)"terraforged:jungle_large", (Object)Float.valueOf(0.4f)), Pair.of((Object)"terraforged:jungle_huge", (Object)Float.valueOf(0.3f)), Pair.of((Object)"minecraft:jungle_bush", (Object)Float.valueOf(0.2f)))));
    }

    private static Modifier<Jsonifiable> pine(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:taiga", "minecraft:taiga_hills", "minecraft:taiga_mountains"), FeatureMatcher.and(Blocks.field_196618_L, Blocks.field_196645_X), FeatureReplacer.of(Trees.poisson(0.25f, 7, 0.25f, 250, 0.7f, "terraforged:pine", new Pair[0])));
    }

    private static Modifier<Jsonifiable> redwood(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:giant_spruce_taiga*", "minecraft:giant_tree_taiga*"), FeatureMatcher.and("minecraft:giant_trunk_placer", Blocks.field_196618_L, Blocks.field_196645_X), FeatureReplacer.of(Trees.context(Trees.contextEntry("terraforged:redwood_huge", 0.4f, Trees.eCntx(0.15f, 0.0f), Trees.bCntx(0.1f, 0.3f)), Trees.contextEntry("terraforged:redwood_large", 0.2f, Trees.eCntx(0.25f, 0.0f), Trees.bCntx(0.05f, 0.25f)), Trees.contextEntry("terraforged:spruce_large", 0.4f, Trees.eCntx(0.35f, 0.15f)), Trees.contextEntry("terraforged:spruce_small", 0.2f, Trees.eCntx(0.5f, 0.2f))).func_227228_a_(Trees.poisson(0.3f, 6, 0.3f, 250, 0.75f))));
    }

    private static Modifier<Jsonifiable> spruce(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:snowy_taiga", "minecraft:snowy_taiga_hills", "minecraft:taiga_mountains"), FeatureMatcher.and("minecraft:tree", Blocks.field_196618_L, Blocks.field_196645_X), FeatureReplacer.of(Trees.poisson(0.3f, 7, 0.25f, 250, 0.75f, "terraforged:pine", new Pair[0])));
    }

    private static Modifier<Jsonifiable> spruceTundra(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, "minecraft:snowy_tundra", "minecraft:snowy_taiga_mountains", "minecraft:gravelly_mountains", "minecraft:modified_gravelly_mountains"), FeatureMatcher.and("minecraft:tree", Blocks.field_196618_L, Blocks.field_196645_X), FeatureReplacer.of(Trees.template("terraforged:pine").func_227228_a_(Placement.field_242898_b.func_227446_a_((IPlacementConfig)new ChanceConfig(80)))));
    }

    private static Modifier<Jsonifiable> willow(TFBiomeContext context) {
        return new Modifier<Jsonifiable>(BiomeMatcher.of(context, Biomes.field_76780_h, Biomes.field_150599_m), FeatureMatcher.and("minecraft:tree", Blocks.field_196642_W, Blocks.field_196617_K), FeatureReplacer.of(Trees.extra(3, 0.05f, 1, "terraforged:willow_large", Pair.of((Object)"terraforged:willow_small", (Object)Float.valueOf(0.2f)), Pair.of((Object)"terraforged:willow_large", (Object)Float.valueOf(0.35f)))));
    }

    @SafeVarargs
    private static ConfiguredFeature<?, ?> extra(int count, float chance, int extra, String def, Pair<String, Float> ... entries) {
        return Trees.select(def, entries).func_227228_a_(Features.Placements.field_243994_e).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, chance, extra)));
    }

    @SafeVarargs
    private static ConfiguredFeature<?, ?> poisson(float scale, int radius, float fade, int densityScale, float densityVariation, String def, Pair<String, Float> ... entries) {
        return Trees.poisson(scale, 0.8f, radius, fade, densityScale, densityVariation, def, entries);
    }

    @SafeVarargs
    private static ConfiguredFeature<?, ?> poisson(float scale, float jitter, int radius, float fade, int densityScale, float densityVariation, String def, Pair<String, Float> ... entries) {
        return Trees.poisson(new FastPoissonConfig(scale, jitter, radius, fade, densityScale, densityVariation), def, entries);
    }

    @SafeVarargs
    private static ConfiguredFeature<?, ?> poisson(FastPoissonConfig config, String def, Pair<String, Float> ... entries) {
        return Trees.select(def, entries).func_227228_a_(Trees.poisson(config));
    }

    private static ConfiguredPlacement<?> poisson(float scale, int radius, float fade, int densityScale, float densityVariation) {
        return Trees.poisson(new FastPoissonConfig(scale, radius, fade, densityScale, densityVariation));
    }

    private static ConfiguredPlacement<?> poisson(FastPoissonConfig config) {
        ConfiguredPlacement poisson = FastPoissonAtSurface.INSTANCE.func_227446_a_(config);
        Optional<ConfiguredPlacement> filtered = PlacementFilter.decode("biome").map(f -> FilterDecorator.INSTANCE.func_227446_a_(new FilterDecoratorConfig((ConfiguredPlacement<?>)poisson, (PlacementFilter)f)));
        if (filtered.isPresent()) {
            return filtered.get();
        }
        return poisson;
    }

    private static ContextModifier bCntx(float from, float to) {
        return Trees.bCntx(from, to, false);
    }

    private static ContextModifier bCntx(float from, float to, boolean exclusive) {
        return new BiomeModifier(from, to, exclusive);
    }

    private static ContextModifier eCntx(float from, float to) {
        return Trees.eCntx(from, to, false);
    }

    private static ContextModifier eCntx(float from, float to, boolean exclusive) {
        return new Elevation(from, to, exclusive);
    }

    private static ContextualFeature contextEntry(String template, float chance, ContextModifier ... contexts) {
        return new ContextualFeature(Trees.template(template), chance, Arrays.asList(contexts));
    }

    @SafeVarargs
    private static ConfiguredFeature<?, ?> select(String def, Pair<String, Float> ... entries) {
        if (entries.length == 0) {
            return Trees.template(def);
        }
        if (entries.length == 1) {
            return Feature.field_202293_am.func_225566_b_((IFeatureConfig)new TwoFeatureChoiceConfig(() -> Trees.template(def), () -> Trees.template((String)entries[0].getFirst())));
        }
        ArrayList<ConfiguredRandomFeatureList> features = new ArrayList<ConfiguredRandomFeatureList>();
        for (Pair<String, Float> entry : entries) {
            features.add(new ConfiguredRandomFeatureList(Trees.getFeature((String)entry.getFirst()), ((Float)entry.getSecond()).floatValue()));
        }
        return Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig(features, Trees.template(def)));
    }

    private static ConfiguredFeature<?, ?> getFeature(String name) {
        if (name.startsWith("terraforged:")) {
            return Trees.template(name);
        }
        return (ConfiguredFeature)WorldGenRegistries.field_243653_e.func_241873_b(new ResourceLocation(name)).orElseThrow(RuntimeException::new);
    }

    private static ConfiguredFeature<?, ?> context(ContextualFeature ... features) {
        return ContextSelectorFeature.INSTANCE.func_225566_b_(new ContextSelectorConfig(Arrays.asList(features)));
    }

    private static ConfiguredFeature<?, ?> template(String name) {
        return TerraFeatures.INSTANCE.func_225566_b_(TemplateManager.getInstance().getTemplateConfig(new ResourceLocation(name)));
    }
}

